// NOBF_ORA8.cpp

#include "stdafx.h"
#include "PCMAG_ORA8.h"
#include "NOBF_ORA8.h"

#if (_NOBF_ORA8_ == TRUE)

#define CHECK_FOR_ERROR_NOBF \
	if (ReturnCode != OCI_SUCCESS) { \
		CString szErrorMsg; \
		szErrorMsg.Format ("OCI error in CHECK_FOR_ERROR_NOBF! ReturnCode = %i", ReturnCode); \
		CSSOutputDebugText (szErrorMsg); \
		HandleError ((WORD)ReturnCode, pMasterError); \
		return FALSE; \
	}

COracle8Driver::COracle8Driver (void)
{
}

COracle8Driver::~COracle8Driver (void)
{
}

BOOL COracle8Driver::DatabaseLogon (void)
{

	// declare variables
	HANDLE hMutex;
	int iMutexReturn;
	int ReturnCode;

	hMutex = CreateMutex (NULL, FALSE, "LoginMutex");
	iMutexReturn = WaitForSingleObject(hMutex, 20000L);

	if (iMutexReturn == WAIT_OBJECT_0) {
		if (bLoggedOn == FALSE) {
			(void) OCIInitialize (OCI_THREADED, (dvoid *)0, (dvoid * (*)(dvoid *, size_t)) 0, (dvoid * (*)(dvoid *, dvoid *, size_t))0, (void (*)(dvoid *, dvoid *)) 0 );
			(void) OCIEnvInit ((OCIEnv**) &pMasterEnvironment, OCI_DEFAULT, (size_t)0, (dvoid **)NULL);
			//(void) OCIEnvCreate ((OCIEnv**) &pMasterEnvironment, OCI_THREADED, (dvoid *)0, (dvoid * (*)(dvoid *, size_t))0, (dvoid * (*)(dvoid *, dvoid *, size_t))0, (void (*)(dvoid *, dvoid *)) 0, (size_t)0, (dvoid **)NULL);
			(void) OCIHandleAlloc ((dvoid *) pMasterEnvironment, (dvoid **)&pMasterError, OCI_HTYPE_ERROR, (size_t)0, (dvoid **)NULL);
			(void) OCIHandleAlloc ((dvoid *) pMasterEnvironment, (dvoid **)&pMasterServer, OCI_HTYPE_SERVER, (size_t)0, (dvoid **)NULL);
			(void) OCIHandleAlloc ((dvoid *) pMasterEnvironment, (dvoid **)&pMasterServerContext, OCI_HTYPE_SVCCTX, (size_t)0, (dvoid **)NULL);
			ReturnCode = OCIServerAttach (pMasterServer, pMasterError, (text *)"pcmag", strlen("pcmag"), 0);
			CHECK_FOR_ERROR_NOBF;
			ReturnCode = OCIAttrSet ((dvoid *) pMasterServerContext, OCI_HTYPE_SVCCTX, (dvoid *)pMasterServer, (ub4) 0, OCI_ATTR_SERVER, (OCIError *)pMasterError);
			CHECK_FOR_ERROR_NOBF;
			(void) OCIHandleAlloc ((dvoid *) pMasterEnvironment, (dvoid **)&pMasterSession, OCI_HTYPE_SESSION, (size_t)0, (dvoid **)NULL);
			ReturnCode = OCIAttrSet ((dvoid *) pMasterSession, OCI_HTYPE_SESSION, (text *) "pcmag", strlen("pcmag"), OCI_ATTR_USERNAME, (OCIError *)pMasterError);
			CHECK_FOR_ERROR_NOBF;
			ReturnCode = OCIAttrSet ((dvoid *) pMasterSession, OCI_HTYPE_SESSION, (text *) "pcmag", strlen("pcmag"), OCI_ATTR_PASSWORD, (OCIError *)pMasterError);
			CHECK_FOR_ERROR_NOBF;
			ReturnCode = OCISessionBegin (pMasterServerContext, pMasterError, pMasterSession, OCI_CRED_RDBMS, OCI_DEFAULT);
			CHECK_FOR_ERROR_NOBF;
			ReturnCode = OCIAttrSet ((dvoid *) pMasterServerContext, OCI_HTYPE_SVCCTX, (dvoid *) pMasterSession, (ub4) 0, OCI_ATTR_SESSION, (OCIError *)pMasterError);
			CHECK_FOR_ERROR_NOBF;
			bLoggedOn = TRUE;
		}
		ReleaseMutex (hMutex);
	}
	else {
		CSSGetErrorLog() << error << "Logon mutex get failed, iMutexReturn = " << iMutexReturn << endmessage;
	}
	return TRUE;

}

BOOL COracle8Driver::DatabaseLogoff (void)
{

	// declare variables
	HANDLE hMutex;
	int iMutexReturn;
	int ReturnCode;

	hMutex = CreateMutex (NULL, FALSE, "LogoffMutex");
	iMutexReturn = WaitForSingleObject(hMutex, 20000L);

	if (iMutexReturn == WAIT_OBJECT_0) {
		if (bLoggedOn == TRUE) {
			if (pMasterSession) {
				ReturnCode = OCIHandleFree (pMasterSession, OCI_HTYPE_SESSION);
				CHECK_FOR_ERROR_NOBF;
			}
			if (pMasterServerContext) {
				ReturnCode = OCIHandleFree (pMasterServerContext, OCI_HTYPE_SVCCTX);
				CHECK_FOR_ERROR_NOBF;
			}
			if (pMasterServer) {
				ReturnCode = OCIServerDetach (pMasterServer, pMasterError, OCI_DEFAULT);
				CHECK_FOR_ERROR_NOBF;
				ReturnCode = OCIHandleFree (pMasterServer, OCI_HTYPE_SERVER);
				CHECK_FOR_ERROR_NOBF;
			};
			if (pMasterError) {
				(void) OCIHandleFree (pMasterError, OCI_HTYPE_ERROR);
			}
			if (pMasterEnvironment) {
				(void) OCIHandleFree (pMasterEnvironment, OCI_HTYPE_ENV);
			}
			bLoggedOn = FALSE;
		}
		ReleaseMutex (hMutex);
	}
	else {
		CSSGetErrorLog() << error << "Logoff mutex get failed, iMutexReturn = " << iMutexReturn << endmessage;
	}
	return TRUE;
}

OCIEnv *COracle8Driver::GetOCIEnvironment (void) {
	return pMasterEnvironment;
}

OCISession *COracle8Driver::GetOCISession (void) {
	return pMasterSession;
}

OCISvcCtx *COracle8Driver::GetOCIServerContext (void) {
	return pMasterServerContext;
}

OCIError *COracle8Driver::GetOCIError (void) {
	return pMasterError;
}

void HandleError (WORD wStatus, OCIError* pError)
{
	text errbuf[512];
	sb4 errcode = 0;
	switch (wStatus) {
		case OCI_SUCCESS:
			CSSGetErrorLog() << error << "OCI_SUCCESS" << endmessage;
			break;
		case OCI_SUCCESS_WITH_INFO:
			CSSGetErrorLog() << error << "OCI Error - OCI_SUCCESS_WITH_INFO" << endmessage;
			break;
		case OCI_NEED_DATA:
			CSSGetErrorLog() << error << "OCI Error - OCI_NEED_DATA" << endmessage;
			break;
		case OCI_NO_DATA:
			CSSGetErrorLog() << error << "OCI Error - OCI_NO_DATA" << endmessage;
			break;
		case OCI_ERROR:
			(void) OCIErrorGet ((dvoid *)pError, (ub4) 1, (text *) NULL, &errcode, (text *)errbuf, (ub4) sizeof(errbuf), OCI_HTYPE_ERROR);
			CSSGetErrorLog() << error << "OCI Error - " << errbuf << endmessage;
			break;
		case OCI_INVALID_HANDLE:
			CSSGetErrorLog() << error << "OCI Error - OCI_INVALID_HANDLE" << endmessage;
			break;
		case OCI_STILL_EXECUTING:
			CSSGetErrorLog() << error << "OCI Error - OCI_STILL_EXECUTING" << endmessage;
			break;  
		case OCI_CONTINUE:
			CSSGetErrorLog() << error << "OCI Error - OCI_CONTINUE" << endmessage;
			break;
		default:
			break;
	}
}

#endif
